local FSM
local Action

sdk.hook(
    sdk.find_type_definition("snow.player.fsm.PlayerFsm2ActionItemUsed")
    :get_method("start"),
    function(args)
        FSM = sdk.to_managed_object(args[2])
        Action = sdk.to_managed_object(args[3])

        local pl = FSM:getPlayerQuestBase(Action)
        if not pl then return end
        
        local itemInfo = pl._ItemInfo
        if not itemInfo then return end

        local itemId = itemInfo._actItemNo

        if itemId ~= 68157445 and itemId ~= 68157907 then return end

        if not pl:isMasterPlayer() then return end
        local plData = pl._refPlayerData

        local EquipManager = sdk.get_managed_singleton("snow.data.EquipDataManager")

        local Health_buffToMax = EquipManager:calcLvBuffNumToMax(2)
        local Stamina_buffToMax = EquipManager:calcLvBuffNumToMax(3)

        if Health_buffToMax > 0 then
            EquipManager:addLvBuffCount(0, Health_buffToMax)
        end
        if Stamina_buffToMax > 0 and itemId == 68157907 then
            EquipManager:addLvBuffCount(1, Stamina_buffToMax)
        end
    end
)

local item
sdk.hook(
    sdk.find_type_definition("snow.player.PlayerQuestBase")
    :get_method("checkIsItemUnnecessary"),
    function(args)
        item = sdk.to_int64(args[3])
    end,
    function(retval)
        if item == 68157445 then return sdk.to_ptr(false) end
    end
)